#!/bin/csh
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1998,2001 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#------------------------------------------------------------------------------
# @(#)36	1.6	src/rsct/ffdc/bin/fcinitstk.csh, ffdc, rsct_rori, roris01a 3/2/99 15:52:51
#------------------------------------------------------------------------------
#
# Module Name:	fcinitstk.csh
#
# Component:	ffdc
#
# Description:	First Failure Data Capture (FFDC) command line interface to the
#		fc_init() API function.  Intended for use from C Shells.
#		Used to createa new FFDC Environment or inherit an existing
#		FFDC Environment.
#
# Notes:	Uses the binary file fcinitstk to carry out its intended
#		function.  fcinitstk handles all parameter verification, and
#		calculates the values needed to be set in the process environ-
#		ment to establish the FFDC Environment.  These values are
#		passed back to this script through standard output, which this
#		script captures.  This script then issues "export" commands
#		to modify the process environment to establish the FFDC
#		environment.
#
#		fcismd is used to display NLS cataloged messages for this script
#		in cases where the fcistm cannot generate meaningful output.
#
# Exit Status:	The exit status from fcinitstk is passed to the caller as the
#		exit status of this command.  This script manually sets an
#		exit status of 39 (FC_NOT_SOURCED) if it detects that the
#		script was not "sourced" from its parent script.
#
#------------------------------------------------------------------------------

# Make a basic check to see if this script is being "sourced" from its parent.
# Unless the script is "sourced", the environment modifications it makes will
# not be assumed by the calling script. Check this by examining $0 of this
# script, and see if it matches the script's own name.  If it does match, then
# the script assumes that it wasn't sourced.
if ( $?0 == 1 ) then
	set script_name=`basename $0`
	if ( "$script_name" == "fcinit.csh" ) then
		/usr/sbin/rsct/bin/fcismd 3
		exit 39
	endif
else
	/usr/sbin/rsct/bin/fcismd 3
	exit 39
endif

# Execute the fcinit command and capture its standard output (let any
# standard error go to wherever standard error is currently directed).  If
# the exit status from the command indicates a problem, halt processing.

set fcinitstk_out=`/usr/sbin/rsct/bin/fcistm -p$0 $*`
set rc=$status

# An exit status of 2 indicates that a help message was generated.  Display
# the help message and exit.
if ( $rc == 2 ) then
	/usr/sbin/rsct/bin/fcismd 1
	/usr/sbin/rsct/bin/fcismd 2
	exit $rc
endif

# Any exit status other than 0 (FFDC Environment created) or 1 (FFDC Environment
# inherited) indicates a failure, and fcinit should not have generated any
# information to standard output.  Error messages were sent to standard error.
# Pass along the exit status and stop.
if ( $rc != 0 ) then
	if ( $rc != 1 ) then
		exit $rc
	endif
endif

# When an FFDC Environment can be created or inherited, fcinit has sent back
# the environment variables to be set in standard output.  Parse this list and
# issue the "export" command on each element to set the process environment.
foreach env_set ($fcinitstk_out)
	set env_var=`echo $env_set | awk -F"=" '{print $1}'`
	set env_val=`echo $env_set | awk -F"=" '{print $2}'`
	setenv $env_var $env_val
end

# Pass along the exit status of fcinit to indicate whether the environment
# was created or inherited
exit $rc
